/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.exceptions.PISystemException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.HWSvrSocket;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class FspSimpleCmds {
    private static FspSimpleCmds mInst;
    private static int SEND_TO_SINGLE_BY_LOC_CODE;
    private static final String SET_CEC_NAME = "SET_CEC_NAME";
    private static final String INITIAL_SYSTEM_DUMP = "INITIAL_SYSTEM_DUMP";
    private static final String DUMP_SERVICE_PROCESSOR = "DUMP_SERVICE_PROCESSOR";
    private static final String CEC_POWER_TRANSITION = "CEC_POWER_TRANSITION";
    private static final String CEC_RE_IPL = "CEC_RE_IPL";
    private static final String TRANSITION_HYPERVISOR_STATE = "TRANSITION_HYPERVISOR_STATE";
    private static final String SET_MASTER_HMC = "SET_MASTER_HMC";
    private static final String NAME = "NAME";
    private static final String GET_MASTER_HMC = "GET_MASTER_HMC";
    private static final String SET_EVENT_NOTIFICATION_MASK = "SET_EVENT_NOTIFICATION_MASK";
    private static final String ACKNOWLEDGE_OUTSTANDING_EVENTS = "ACKNOWLEDGE_OUTSTANDING_EVENTS";
    private static final String GET_PENDING_EVENTS = "GET_PENDING_EVENTS";
    private static final String DATA = "DATA";
    private static final String BROADCAST_MESSAG = "BROADCAST_MESSAG";
    private static final String ACKNOWLEDGE_PLATFORM_EVENT_LOG_ENTRY = "ACKNOWLEDGE_PLATFORM_EVENT_LOG_ENTRY";
    private static final String SET_HMC_LOCKS = "SET_HMC_LOCKS";
    private static final String ERROR_TYPE = "ERROR_TYPE";
    private static final String RESET_HMC_LOCKS = "RESET_HMC_LOCKS";
    private static final String DISCONNECT_HMC = "DISCONNECT_HMC";
    private static final String GET_PROCESSOR_FEATURE_CODE = "GET_PROCESSOR_FEATURE_CODE";
    private static final String FEATURE_CODE = "FEATURE_CODE";

    static FspSimpleCmds getInstance() {
        if (mInst == null) {
            mInst = new FspSimpleCmds();
        }
        return mInst;
    }

    void setCecNameCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        String string2 = ByteUtilities.toHexString(FspSimpleCmds.javaToFSPString(string));
        Hashtable hashtable = fSPCmdMgr.doFSPCommand(SET_CEC_NAME, new String[]{string2});
    }

    public static final byte[] javaToFSPString(String string) {
        byte[] byArray = null;
        int n = 2 + string.length();
        n += 4 - n % 4;
        byArray = new byte[n];
        byArray[0] = (byte)(n - 2 >> 8 & 0xFF);
        byArray[1] = (byte)(n - 2 & 0xFF);
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
        System.arraycopy(byArray2, 0, byArray, 2, string.length());
        return byArray;
    }

    private static void debug(String string) {
        System.out.println("| FspSimpleCmds." + string);
    }

    void initializeDumpCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        String[] stringArray = new String[]{"0"};
        Hashtable hashtable = null;
        if ("PRIMARY".equals(string)) {
            FspSimpleCmds.debug("calling initiate system dump doFSPCommand to CEC FSP");
            hashtable = fSPCmdMgr.doFSPCommand(INITIAL_SYSTEM_DUMP, stringArray);
        } else if ("SIDE_A".equals(string) || "SIDE_B".equals(string)) {
            FspSimpleCmds.debug("calling initiate system dump doFSPCommand to BPC FSP");
            hashtable = fSPCmdMgr.doFSPCommand(INITIAL_SYSTEM_DUMP, stringArray, 0, null, SEND_TO_SINGLE_BY_LOC_CODE, string);
        }
    }

    void dumpServiceProcessor(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        String[] stringArray = null;
        Hashtable hashtable = null;
        if ("PRIMARY".equals(string)) {
            FspSimpleCmds.debug("calling dump service processor doFSPCommand to CEC FSP");
            hashtable = fSPCmdMgr.doFSPCommand(DUMP_SERVICE_PROCESSOR, stringArray);
        } else if ("SIDE_A".equals(string) || "SIDE_B".equals(string)) {
            FspSimpleCmds.debug("calling dump service processor doFSPCommand to BPC FSP");
            hashtable = fSPCmdMgr.doFSPCommand(DUMP_SERVICE_PROCESSOR, stringArray, 0, null, SEND_TO_SINGLE_BY_LOC_CODE, string);
        }
    }

    void setCecStateCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt8 unsignedInt8) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        String[] stringArray = new String[]{unsignedInt8.toString()};
        hashtable = fSPCmdMgr.doFSPCommand(CEC_POWER_TRANSITION, stringArray);
    }

    void reIplCecCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        hashtable = fSPCmdMgr.doFSPCommand(CEC_RE_IPL, null);
    }

    void transitHypStateCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt8 unsignedInt8) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        String[] stringArray = new String[]{unsignedInt8.toString()};
        hashtable = fSPCmdMgr.doFSPCommand(TRANSITION_HYPERVISOR_STATE, stringArray);
    }

    String setMasterHMCCmd(FSPCmdMgr fSPCmdMgr, int n) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        String string = null;
        hashtable = fSPCmdMgr.doFSPCommand(SET_MASTER_HMC, new String[]{"" + n});
        byte[] byArray = (byte[])hashtable.get(NAME);
        string = new String(byArray).trim();
        return string;
    }

    String getMasterHMCCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        String string = null;
        hashtable = fSPCmdMgr.doFSPCommand(GET_MASTER_HMC, null);
        byte[] byArray = (byte[])hashtable.get(NAME);
        string = new String(byArray).trim();
        return string;
    }

    void setEventNotificationMaskCmd(FSPCmdMgr fSPCmdMgr, byte[] byArray) throws PIHscServerException {
        String string = ByteUtilities.toHexString(byArray);
        fSPCmdMgr.doFSPCommand(SET_EVENT_NOTIFICATION_MASK, new String[]{"" + byArray.length, string});
    }

    void acknowledgeOutstandingEventsCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException {
        fSPCmdMgr.doFSPCommand(ACKNOWLEDGE_OUTSTANDING_EVENTS, null);
    }

    byte[] getPendingEventsCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException {
        Hashtable hashtable = fSPCmdMgr.doFSPCommand(GET_PENDING_EVENTS, null);
        return (byte[])hashtable.get(DATA);
    }

    void broadcastMessageCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt8 unsignedInt8, UnsignedInt32 unsignedInt32, String string, byte[] byArray) throws PIHscServerException {
        String string2 = ByteUtilities.toHexString(byArray);
        int n = 11;
        if (string == null) {
            string = " ";
        }
        n += string.length();
        if (unsignedInt32 == null) {
            unsignedInt32 = new UnsignedInt32(0L);
        }
        fSPCmdMgr.doFSPCommand(BROADCAST_MESSAG, new String[]{"" + n, unsignedInt8.toString(), "0", "" + byArray.length, "0", unsignedInt32.toString(), "" + string.length(), string2});
    }

    void acknowledgePlatformEventLogEntryCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt32 unsignedInt32) throws PIHscServerException, PIHscCmdMgrException {
        fSPCmdMgr.doFSPCommand(ACKNOWLEDGE_PLATFORM_EVENT_LOG_ENTRY, new String[]{unsignedInt32.toString()});
    }

    void acknowledgePlatformEventLogEntryCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt32 unsignedInt32, String string) throws PIHscServerException, PIHscCmdMgrException {
        fSPCmdMgr.doFSPCommand(ACKNOWLEDGE_PLATFORM_EVENT_LOG_ENTRY, new String[]{unsignedInt32.toString()}, string);
    }

    void setHmcLocksCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, UnsignedInt8[] unsignedInt8Array) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        byte[] byArray = null;
        for (int i = 0; i < unsignedInt8Array.length; ++i) {
            byArray[i] = unsignedInt8Array[i].byteValue();
        }
        String string = ByteUtilities.toHexString(byArray);
        hashtable = fSPCmdMgr.doFSPCommand(SET_HMC_LOCKS, new String[]{unsignedInt16.toString(), "" + unsignedInt8Array.length, unsignedInt162.toString(), string});
        int n = (Integer)hashtable.get(ERROR_TYPE);
        if (n != 0) {
            throw new PISystemException(SET_HMC_LOCKS, n);
        }
    }

    void resetHmcLocksCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, UnsignedInt8[] unsignedInt8Array) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        byte[] byArray = null;
        for (int i = 0; i < unsignedInt8Array.length; ++i) {
            byArray[i] = unsignedInt8Array[i].byteValue();
        }
        String string = ByteUtilities.toHexString(byArray);
        hashtable = fSPCmdMgr.doFSPCommand(RESET_HMC_LOCKS, new String[]{unsignedInt16.toString(), "" + unsignedInt8Array.length, unsignedInt162.toString(), string});
        int n = (Integer)hashtable.get(ERROR_TYPE);
        if (n != 0) {
            throw new PISystemException(RESET_HMC_LOCKS, n);
        }
    }

    void disconnectHmcCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        int n = 1213023008;
        HWSvrSocket hWSvrSocket = HWSvrSocket.getInstance();
        String string2 = hWSvrSocket.getHmcId();
        System.out.println("FspSimpleCmds->disconnectHMC(): sourceHMCVPD=" + string2 + "; targetHMCVPD=" + string);
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            throw new PIHscServerException("0258");
        }
        fSPCmdMgr.doFSPCommand(DISCONNECT_HMC, new String[]{String.valueOf(n), String.valueOf(string.length()), string, String.valueOf(n), String.valueOf(string2.length()), string2});
    }

    public String getProcessorFeatureCode(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doFSPCommand(GET_PROCESSOR_FEATURE_CODE);
        String string = (String)hashtable.get(FEATURE_CODE);
        return string;
    }

    static {
        SEND_TO_SINGLE_BY_LOC_CODE = 1;
    }
}

